import { UseFormWatch } from "react-hook-form";

import { Permission, RoleT } from "@/types/roleAndPermissions";

import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { useState } from "react";
import { StrReplacer } from "@/lib/utils";
import { EyeIcon, EyeOffIcon } from "lucide-react";
import style from "../../style.module.scss";
import {
  AddressSchemaT,
  CustomerManageSchemaT,
  DncCheckerSchemaT,
} from "./schema";
import { CustomerDetailsPlaceholder } from "../customer-manage/[[...slug]]/page";

type CustomerFormPreview = {
  watch: UseFormWatch<
    CustomerManageSchemaT & AddressSchemaT & AddressSchemaT & DncCheckerSchemaT
  >;
  placeholder: CustomerDetailsPlaceholder | undefined;
};

export default function CustomerFormPreview({
  watch,
  placeholder,
}: CustomerFormPreview) {
  const firstName = watch("first_name");
  // const customerId = watch("customer_id");
  const lastName = watch("last_name");
  const email = watch("email");
  const landline = watch("home_phone");
  const mobile = watch("mobile_phone");
  const title = watch("title");
  // const dnc = watch("dnc");
  const iso = watch("iso");
  const assignedTo = watch("assigned_to_id");
  const address = watch("address");

  return (
    <div className="right-card h-fit bg-yellowish/20 rounded-sm flex flex-col items-center py-20 space-y-10">
      <Avatar className="w-28 h-28">
        <AvatarImage src="/assets/images/user.png" />
        <AvatarFallback>Profile</AvatarFallback>
      </Avatar>

      {/* <p className="text-danger">{` Customer Id : ${customerId || "NA"} `}</p> */}

      <p className="text-danger">{` Name : ${title || ""} ${firstName || ""}  ${
        lastName || ""
      }`}</p>

      <div className="grid grid-cols-2 gap-16 ">
        <p className="text-danger text-center">Email : {email}</p>
        <p className="text-danger text-center">DNC : {placeholder?.dnc}</p>
        <p className="text-danger text-center">Landline : {landline}</p>
        <p className="text-danger text-center">Mobile : {mobile}</p>
        <p className="text-danger text-center">ISO : {iso}</p>
        <p className="text-danger text-center">
          Assigned To : {placeholder?.assigned_to_id}
        </p>
      </div>

      <div className="w-full flex gap-2 px-5 flex-wrap">
        {address?.map((fields, index) => {
          return (
            <div key={index} className="border space-y-1 p-2">
              <p className="text-danger ">{`Address1 : ${fields.address1}`}</p>
              <p className="text-danger ">{`Address1 : ${fields.address2}`}</p>
              <p className="text-danger ">{`Country : ${fields.country}`}</p>
              <p className="text-danger ">{`County : ${fields.county}`}</p>
              <p className="text-danger ">{`Town City : ${fields.town_city}`}</p>
              <p className="text-danger ">{`Post Code : ${fields.post_code}`}</p>
              <p className="text-danger ">
                Is primary address : {fields.primary ? "Yes" : "No"}
              </p>
            </div>
          );
        })}
      </div>
    </div>
  );
}

function PasswordToggler({ password }: { password: string }) {
  const [show, setShow] = useState(false);
  const pasLen = StrReplacer(password);
  function toggle() {
    setShow((prev) => !prev);
  }

  return (
    <div className="flex gap-8 items-center">
      <p className="inline-block align">{show ? password : pasLen}</p>
      {show ? (
        <EyeOffIcon className="scale-75" onClick={() => toggle()} />
      ) : (
        <EyeIcon className="scale-75" onClick={() => toggle()} />
      )}
    </div>
  );
}
