"use client";
import { MenuSliderHandler } from "@/components/menu-slider";
import TableHydrate from "@/components/pages/home/tableHydrate";
import useUserStore from "@/store/useUserStore";
import { useRouter } from "next/navigation";
import { useEffect, useState } from "react";
import { getCookie } from "@/lib/getCookie";

const fallback: any = [];

type Repo = {
  name: string;
  stargazers_count: number;
};

const User = ({ searchParams }: any) => {
  const router = useRouter();
  const data = useUserStore((state) => state.data);
  const setUserData = useUserStore((state) => state.setUserData);
  const [hydrated, setHydrated] = useState(false);

  useEffect(() => {
    setHydrated(true);
  }, []);

  useEffect(() => {
    if (!hydrated) return;
    if (!data) {
      const cookie = getCookie("auth");
      if (cookie) {
        setUserData(JSON.parse(cookie));
      } else {
        router.push("/login");
      }
    }
  }, [hydrated, data, router, setUserData]);

  function rowHandler(data: any) {
    console.log(data);
    MenuSliderHandler();
  }

  console.log(searchParams);

  // Render nothing while redirecting
  if (!hydrated || !data || Object.keys(data).length === 0) {
    return null;
  }

  return (
    <div>
      <div className="relative">
        <TableHydrate
          offset={Number(searchParams.offset) || 0}
          limit={Number(searchParams.limit) || 10}
        />
      </div>
    </div>
  );
};

export default User;