"use client";
import React, { ReactNode, useRef, useState } from "react";
import style from "./style.module.scss";
import { Ellipsis, X } from "lucide-react";
import { Root, createRoot } from "react-dom/client";
import useMenuSliderStore from "@/store/useMenuSliderStore";
import gsap from "gsap";
import { useGSAP } from "@gsap/react";
import { Badge } from "../ui/badge";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";

type MenuSliderT = {
  onClose: () => void;
};

const logs = [
  "May 21 10: 20 : 01 Added Permission for User",
  "May 21 10: 20 : 01 Added Permission for User",
  "May 21 10: 20 : 01 Added Permission for User",
  "May 21 10: 20 : 01 Added Permission for User",
];

const MenuSlider = ({ onClose }: MenuSliderT) => {
  const container = useRef<HTMLDivElement>(null);
  const { innerElement, optionsElement } = useMenuSliderStore();
  const [queryClient] = useState(() => new QueryClient());

  // useGSAP(() => {
  //   gsap.from(container.current, {
  //     startAt: {
  //       opacity: 1,
  //       x: "0%",
  //     },
  //     opacity: 0,
  //     x: "100%",
  //   });

  //   return () => {
  //     console.log("exit");
  //   };
  // });

  return (
    <QueryClientProvider client={queryClient}>
      <div
        ref={container}
        onClick={(e) => {
          e.stopPropagation();
          onClose();
        }}
        className=" transparent h-screen w-screen fixed top-0 bottom-4 z-50 translate-x-0"
      >
        <div
          onClick={(e) => {
            e.stopPropagation();
          }}
          className="bg-yellowish/30 absolute right-0 top-1/2 -translate-y-1/2 w-96 h-[39rem]  overflow-hidden overflow-y-scroll flex flex-col space-y-4 px-8 pt-14"
        >
          <div className="absolute right-1 top-0 flex items-center gap-4 mt-">
            {/* <Ellipsis className="cursor-pointer" /> */}
            {optionsElement}
            <X className="cursor-pointer" onClick={onClose} />
          </div>

          {innerElement}
        </div>
      </div>
    </QueryClientProvider>
  );
};

export function InnerCard({ children }: { children: ReactNode }) {
  return <div className={style.innerCard}>{children}</div>;
}

export default MenuSlider;

function checkElementExists() {
  return document.getElementById("menu-slider");
}

export function MenuSliderHandler() {
  let confirmRoot: Element;
  let root: Root;

  if (checkElementExists()!!) {
    root = createRoot(checkElementExists()!);
    // root.render(<MenuSlider onClose={closeHandler} />);
  } else {
    confirmRoot = document.createElement("div");
    confirmRoot.setAttribute("id", "menu-slider");
    document.querySelector("body")?.appendChild(confirmRoot);
    root = createRoot(confirmRoot);
  }
  const { toggle } = useMenuSliderStore.getState();

  return new Promise((res) => {
    function closeHandler() {
      root.unmount();
      toggle();
      res("");
      return;
    }

    root.render(<MenuSlider onClose={closeHandler} />);
  });
}
