import { useState, useEffect } from "react";

interface TimeLeft {
  days: number;
  hours: number;
  minutes: number;
  seconds: number;
}

const useCountdownTimer = (targetDate: string): TimeLeft => {
  const [days, setDays] = useState(0);
  const [hours, setHours] = useState(0);
  const [minutes, setMinutes] = useState(0);
  const [seconds, setSeconds] = useState(0);

  useEffect(() => {
    // targetDate.setDate(targetDate.getDate() + 7);
    const target = new Date(targetDate);

    const interval = setInterval(() => {
      const now = new Date();
      const difference = target.getTime() - now.getTime();

      const d = Math.floor(difference / (1000 * 60 * 60 * 24));
      setDays(d || 0);

      const h = Math.floor(
        (difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
      );
      setHours(h || 0);

      const m = Math.floor((difference % (1000 * 60 * 60)) / (1000 * 60));
      setMinutes(m || 0);

      const s = Math.floor((difference % (1000 * 60)) / 1000);
      setSeconds(s || 0);
    }, 1000);

    return () => clearInterval(interval);
  }, []);

  return {
    days,
    hours,
    minutes,
    seconds,
  };
};

export default useCountdownTimer;
