export function getRandomDarkColor() {
  // Function to calculate the brightness of a color
  function brightness(r: number, g: number, b: number) {
    return (r * 299 + g * 587 + b * 114) / 1000;
  }

  let r, g, b, brightnessValue;

  do {
    // Generate random values for RGB components
    r = Math.floor(Math.random() * 128); // 0-127
    g = Math.floor(Math.random() * 128); // 0-127
    b = Math.floor(Math.random() * 128); // 0-127

    // Calculate the brightness of the color
    brightnessValue = brightness(r, g, b);
  } while (brightnessValue < 40 || brightnessValue > 180); // Ensure the color is not too dark or too light

  // Convert RGB components to hexadecimal format
  const hexR = r.toString(16).padStart(2, "0");
  const hexG = g.toString(16).padStart(2, "0");
  const hexB = b.toString(16).padStart(2, "0");

  // Combine the hexadecimal components into a color string
  return `#${hexR}${hexG}${hexB}`;
}
