import { create } from "zustand";

interface State {
  customers: number[];
}

interface Action {
  setCustomers: (customers: number[]) => void;
  addCustomer: (customer: number) => void;
  removeCustomer: (customer: number) => void;
}

export const useCustomerStore = create<State & Action>()((set) => ({
  customers: [],
  setCustomers: (customers: number[]) => {
    set((state) => ({ customers }));
  },
  addCustomer: (customer) => {
    set((state) => ({ customers: [...state.customers, customer] }));
  },
  removeCustomer: (customer: number) => {
    set((state) => ({
      customers: state.customers.filter((cust) => cust !== customer),
    }));
  },
}));
