import { create } from "zustand";

interface UseGlobalSearchStoreT {
  gSearch: string;
  setGSearch: (value: string) => void;
}

const useGlobalSearchStore = create<UseGlobalSearchStoreT>()((set) => ({
  gSearch: "",
  setGSearch: (value) => {
    set((state) => ({ gSearch: value }));
  },
}));

export default useGlobalSearchStore;
