import { UserListT } from "@/types/user";
import { ReactNode } from "react";
import { create } from "zustand";

interface UseMenuSliderStoreT {
  open: boolean;
  userData: UserListT | null;
  setUserData: (data: UserListT) => void;
  toggle: () => void;
  innerElement: ReactNode;
  optionsElement: ReactNode;
  setInnerElement: (element: ReactNode) => void;
  setOptionsElement: (element: ReactNode) => void;
}

const useMenuSliderStore = create<UseMenuSliderStoreT>()((set) => ({
  open: false,
  userData: null,
  innerElement: null,
  optionsElement: null,
  toggle: () => {
    set((state) => ({ open: state.open! }));
  },
  setUserData(data: UserListT) {
    set((state) => ({ userData: data }));
  },
  setInnerElement(element) {
    set((state) => ({ innerElement: element }));
  },
  setOptionsElement(element) {
    set((state) => ({ optionsElement: element }));
  },
}));

export default useMenuSliderStore;
