import { string } from "yup";

// Define Permission interface
export interface Permission {
  id: number;
  name: string;
  codename: string;
  content_type: number;
}

export interface UserT {
  data: UserDataT;
  success: boolean;
  message: string;
  status: number;
}

export interface UserDataT {
  name: string;
  email: string;
  role: string;
  tokens: Tokens;
  permissions: Permission[];
}

export interface Tokens {
  refresh: string;
  access: string;
}

export interface GenerateOTP {
  data: null;
  success: boolean;
  message: string;
  status: number;
}

export interface RespError {
  status: number;
  success: boolean;
  message: string;
  data: Data;
}

export interface Data {
  [key: string]: any;
}