export interface ProductT {
  id: number;
  name: string;
  description?: string;
  createdAt: Date;
  updatedAt: Date;
  isActive: boolean;
}

export interface OrderItemT {
  id: number;
  orderId: number;
  productId: number;
  product: ProductT;
  count: number;
  createdAt: Date;
  updatedAt: Date;
}

export interface OrderT {
  id: number;
  orderNumber: string;
  customerId: number;
  customer?: {
    id: number;
    customerId: string;
    firstName?: string;
    lastName?: string;
  };
  createdById: number;
  createdBy?: {
    id: number;
    name?: string;
    firstName?: string;
    lastName?: string;
    email: string;
  };
  createdAt: Date;
  updatedAt: Date;
  isActive: boolean;
  orderItems: OrderItemT[];
}

export interface CreateOrderDto {
  customerId: number;
  orderItems: {
    productId: number;
    count: number;
  }[];
}

export interface CreateProductDto {
  name: string;
  description?: string;
}

