import { emailSchema } from "@/app/(auth)/_schema";
import { InferType, array, number, object, string } from "yup";

export const addUserSchema = object({
  user: object({
    name: string().required("Please enter name"),
  }).concat(emailSchema),
  reports_to_id: string(),
  role_id: string().required("Please enter user role"),
  permissions: array().of(string()).min(1, "Please select at least one."),
});

export type AddUserSchemaT = InferType<typeof addUserSchema>;
