"use client";

import React from "react";
import { PaginationState } from "@tanstack/react-table";

function usePagination(page: number = 0, limit: number = 10) {
  const [pagination, setPagination] = React.useState<PaginationState>({
    pageIndex: page,
    pageSize: limit,
  });

  return { pagination, setPagination };
}

export default usePagination;
