import { UserListT } from "@/types/user";
import { create } from "zustand";

interface useConfirmDialogStoreT {
  open: boolean;
  toggle: () => void;
}

const useConfirmDialogStore = create<useConfirmDialogStoreT>()((set) => ({
  open: false,
  toggle: () => {
    set((state) => ({ open: state.open! }));
  },
}));

export default useConfirmDialogStore;
