import { InferType, number, object, string } from "yup";

export const emailSchema = object({
  email: string()
    .required("Please enter email")
    .matches(
      /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
      {
        message: "Please enter valid email",
      }
    )
    .typeError("Please Enter Valid Email"),
});

export type EmailSchemaT = InferType<typeof emailSchema>;

export const otpSchema = object({
  otp: number().min(6).typeError("Must be 5 numbers").required(),
});

export type OtpSchemaT = InferType<typeof otpSchema>;
