"use client";

import { deleteUserAuthData } from "@/actions/cookies";
import Axios from "@/lib/Axios";
import useGlobalSearchStore from "@/store/useGlobalSearchStore";
import useUserStore from "@/store/useUserStore";
import { useMutation } from "@tanstack/react-query";
import { AxiosError, AxiosResponse } from "axios";
import Image from "next/image";
import { useRouter } from "next/navigation";
import { confirmModla } from "../confirm-dialog";
import { Avatar, AvatarFallback, AvatarImage } from "../ui/avatar";
import { useToast } from "../ui/use-toast";

const Navbar = () => {
  const { toast } = useToast();
  const { data, setLogout } = useUserStore();
  const router = useRouter();

  const { setGSearch } = useGlobalSearchStore();

  const mutation = useMutation<
    AxiosResponse<{ message: string }>,
    AxiosError<any>
  >({
    mutationFn: makeLogout,
    onError: async (error, variables, context) => {
      toast({
        variant: "destructive",
        title: "Error",
        description: error.message,
      });
      await deleteUserAuthData();
      setLogout();
      router.push("/login");
    },
    onSuccess: async (data, variables, context) => {
      await deleteUserAuthData();
      setLogout();
      toast({
        title: "Success!",
        description: data.data.message,
      });
      router.push("/login");
    },
  });

  function makeLogout() {
    return Axios.post("/core/logout/", {
      refresh_token: data?.tokens?.refresh,
    });
  }

  return (
    <div className="px-10 py-5 flex justify-between items-center">
      {/* {JSON.stringify(data) + "c"} */}
      <div className="flex items-center">
        <Image
          src="/assets/images/logo.png"
          width={100}
          height={100}
          alt="nav-logo"
        />

        {/* <div className="ml-10 w-96">
          <Input
            placeholder="search"
            onChange={(e) => setGSearch(e.currentTarget.value)}
          />
        </div> */}
      </div>

      <div className="flex gap-5">
        {/* <svg
          id="notification"
          xmlns="http://www.w3.org/2000/svg"
          width="31.091"
          height="34.557"
          viewBox="0 0 31.091 34.557"
        >
          <g id="Group_249" data-name="Group 249">
            <path
              id="Path_238"
              data-name="Path 238"
              d="M44.607,21.854V15.289A11.488,11.488,0,0,0,37.218,4.57a3.915,3.915,0,0,0,.078-.764,3.792,3.792,0,1,0-7.584,0,4.091,4.091,0,0,0,.072.741,11.129,11.129,0,0,0-7.384,10.5v6.805a.44.44,0,0,1-.439.44,3.988,3.988,0,0,0-3.986,3.523,3.9,3.9,0,0,0,3.87,4.281h6.7a4.992,4.992,0,0,0,9.927,0h6.7a3.894,3.894,0,0,0,2.876-1.276,3.9,3.9,0,0,0-2.992-6.527.437.437,0,0,1-.439-.44ZM33.5,2.229a1.576,1.576,0,0,1,1.571,1.577,1.367,1.367,0,0,1-.022.212,9.8,9.8,0,0,0-1.144-.106,11.4,11.4,0,0,0-1.954.112,1.368,1.368,0,0,1-.022-.212A1.578,1.578,0,0,1,33.5,2.229Zm0,30.1a2.788,2.788,0,0,1-2.72-2.229h5.441A2.788,2.788,0,0,1,33.5,32.327Zm13.319-6.3a1.664,1.664,0,0,1-1.66,1.839H21.845a1.672,1.672,0,0,1-1.66-1.839,1.747,1.747,0,0,1,1.777-1.5,2.668,2.668,0,0,0,2.659-2.67V15.049A8.9,8.9,0,0,1,33.5,6.131c.111,0,.216,0,.328.006a9.1,9.1,0,0,1,8.555,9.152v6.566a2.668,2.668,0,0,0,2.659,2.67A1.751,1.751,0,0,1,46.823,26.029Z"
              transform="translate(-17.958 0)"
            />
          </g>
        </svg> */}

        <div className="flex gap-5">
          <Avatar>
            <AvatarImage src="/assets/images/user.png" />
            <AvatarFallback>Profile</AvatarFallback>
          </Avatar>

          <div className="flex flex-col">
            <p className="text-base">{data?.name || ""}</p>
            <p className="text-sm flex items-center gap-2">
              {data?.role || ""}{" "}
              <span
                className="cursor-pointer"
                onClick={async () => {
                  const resp = await confirmModla(
                    "Are you sure you want to logout?"
                  );
                  if (resp) {
                    mutation.mutate();
                  }
                }}
              >
                <svg
                  id="layer1"
                  xmlns="http://www.w3.org/2000/svg"
                  width="14.656"
                  height="13.726"
                  viewBox="0 0 14.656 13.726"
                >
                  <path
                    id="path52"
                    d="M7.849,291.179a.756.756,0,0,0-.517.207.669.669,0,0,0-.209.49v5.517a.735.735,0,0,0,1.467,0v-5.517a.669.669,0,0,0-.215-.5.757.757,0,0,0-.527-.2Zm4.276,1.383c-.024,0-.048,0-.072,0a.725.725,0,0,0-.637.48.665.665,0,0,0,.231.737A5.385,5.385,0,0,1,13.72,298a5.689,5.689,0,0,1-5.859,5.527A5.694,5.694,0,0,1,2,298a5.377,5.377,0,0,1,2.05-4.2.662.662,0,0,0,.082-.972.765.765,0,0,0-1.033-.077A6.744,6.744,0,0,0,.529,298a7.141,7.141,0,0,0,7.332,6.906A7.134,7.134,0,0,0,15.185,298a6.741,6.741,0,0,0-2.591-5.268.76.76,0,0,0-.47-.17Z"
                    transform="translate(-0.529 -291.179)"
                    fill="#5c290c"
                  />
                </svg>
              </span>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Navbar;
