import { UserDataT } from "@/types/auth";
import { create } from "zustand";
import { persist } from "zustand/middleware";

type UserStoreT = {
  data: UserDataT | undefined;
  setUserData: (data: UserDataT) => void;
  setLogout: () => void;
};

const useUserStore = create<UserStoreT>()(
  persist(
    (set) => ({
      data: undefined,
      setUserData: (data: UserDataT) => {
        set((state) => ({ data }));
      },
      setLogout: () => {

        set((state) => ({ data: undefined }));
      },
    }),
    { name: "userStore" }
  )
);

export default useUserStore;
