import { UserListT } from "./user";

export interface CustomerDataT {
  id: number;
  customer_notes: any[];
  address: AddressT[];
  created_at: Date;
  updated_at: Date;
  is_active: boolean;
  title: string;
  customer_id: null | string;
  gen_customer_id: null | string;
  first_name: string;
  last_name: string;
  email: string;
  mobile_phone: null | string;
  home_phone: string;
  iso: null | string;
  DNC: boolean;
  assigned_to: UserListT | null;
  created_by: UserListT | null;
  is_land_line_default: boolean | null;
}

export interface AddressT {
  id: number;
  created_at: Date;
  updated_at: Date;
  is_active: boolean;
  address1: string;
  address2: string;
  town_city: string;
  county: string;
  country: string;
  post_code: string;
  primary: boolean;
  formatted_address: null;
}
