"use server";
import { UserDataT } from "@/types/auth";
import { RequestCookie } from "next/dist/compiled/@edge-runtime/cookies";
import { cookies } from "next/headers";

export async function setUserAuthData(data: UserDataT) {
  cookies().set("auth", JSON.stringify(data), {
    maxAge: 60 * 60 * 24, // 1 day in seconds
    path: "/",
    // Optionally:
    // httpOnly: true,
    // secure: true,
    // sameSite: "lax",
  });
}

export async function getUserAuthData() {
  return cookies().get("auth");
}

export async function deleteUserAuthData() {
  cookies().delete("auth");
}
