import { type ClassValue, clsx } from "clsx";
import { cookies } from "next/headers";
import { twMerge } from "tailwind-merge";

export function cn(...inputs: ClassValue[]) {
  return twMerge(clsx(inputs));
}

export type ConvertHHMMSST = {
  hours: string;
  minutes: string;
  seconds: string;
};

export function convertHHMMSS(number: number): ConvertHHMMSST {
  const timeStr = number.toString().padStart(6, "0"); // Ensure the string is 6 characters long
  const hours = timeStr.slice(0, 2);
  const minutes = timeStr.slice(2, 4);
  const seconds = timeStr.slice(4);
  return {
    hours,
    minutes,
    seconds,
  };
}

export function StrReplacer(str: string, replacer: string = "*") {
  let appendStr = "";
  for (let i = 0; i < str.length; i++) appendStr += replacer;

  return appendStr;
}

export const accessKeyMapper = (path: string, object: any) => {
  return path.split(".").reduce((o, i) => o[i], object);
};

export function toTitleCase(str: string) {
  const st = String(str);
  if (!st) {
    return "";
  }
  const strArr = st.split(" ").map((word) => {
    return word[0].toUpperCase() + word.substring(1).toLowerCase();
  });
  return strArr.join(" ");
}

export function makeCapitalize(str: string) {
  if (!str) return "";
  const dt = str.split(" ");

  const d = dt.map((item) => {
    return item.charAt(0).toUpperCase() + item.slice(1);
  });

  return d.join().replaceAll(",", " ");
}

export function returnErrorMessage(
  errorObj: Record<string, Array<string> | string>
) {
  let message = "";
  for (let key in errorObj) {
    if (errorObj.hasOwnProperty(key)) {
      let value = errorObj[key];
      if (Array.isArray(value)) {
        message += key + " " + value[0] + "\n";
      } else {
        message += key + " " + value + "\n";
      }
    }
  }
  return message;
}
