import { Permission } from "./roleAndPermissions";

export interface UserListT {
  id: number;
  user: UserT;
  granted_permissions: Permission[];
  created_at: Date;
  updated_at: Date;
  is_active: boolean;
  reports_to: UserListT | null;
  role: Role | null;
}

export interface Role {
  id: number;
  name: string;
  permissions: Permission[];
}

export interface UserT {
  email: string;
  name: string;
  last_login: Date | null;
}
